/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block.ITileBound;
import vazkii.botania.api.block.IWandBindable;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemTwigWand
extends Item {
    private static final String TAG_COLOR1 = "color1";
    private static final String TAG_COLOR2 = "color2";
    private static final String TAG_BOUND_TILE_X = "boundTileX";
    private static final String TAG_BOUND_TILE_Y = "boundTileY";
    private static final String TAG_BOUND_TILE_Z = "boundTileZ";
    private static final String TAG_BIND_MODE = "bindMode";
    public final ChatFormatting modeChatFormatting;

    public ItemTwigWand(ChatFormatting formatting, Item.Properties builder) {
        super(builder);
        this.modeChatFormatting = formatting;
    }

    private static boolean tryCompleteBinding(BlockPos src, ItemStack stack, UseOnContext ctx) {
        BlockPos dest = ctx.m_8083_();
        if (!dest.equals((Object)src)) {
            ItemTwigWand.setBindingAttempt(stack, ITileBound.UNBOUND_POS);
            BlockEntity srcTile = ctx.m_43725_().m_7702_(src);
            if (srcTile instanceof IWandBindable) {
                IWandBindable bindable = (IWandBindable)srcTile;
                if (bindable.bindTo(ctx.m_43723_(), stack, dest, ctx.m_43719_())) {
                    ItemTwigWand.doParticleBeamWithOffset(ctx.m_43725_(), src, dest);
                    ItemTwigWand.setBindingAttempt(stack, ITileBound.UNBOUND_POS);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean tryFormEnchanter(UseOnContext ctx) {
        BlockPos pos;
        Level world = ctx.m_43725_();
        Direction.Axis axis = TileEnchanter.canEnchanterExist(world, pos = ctx.m_8083_());
        if (axis != null) {
            if (!world.f_46443_) {
                world.m_46597_(pos, (BlockState)ModBlocks.enchanter.m_49966_().m_61124_(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)axis));
                world.m_5594_(null, pos, ModSounds.enchanterForm, SoundSource.BLOCKS, 1.0f, 1.0f);
                PlayerHelper.grantCriterion((ServerPlayer)ctx.m_43723_(), ResourceLocationHelper.prefix("main/enchanter_make"), "code_triggered");
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    double x = (Math.random() - 0.5) * 6.0;
                    double y = (Math.random() - 0.5) * 6.0;
                    double z = (Math.random() - 0.5) * 6.0;
                    float velMul = 0.07f;
                    float motionx = (float)(-x) * velMul;
                    float motiony = (float)(-y) * velMul;
                    float motionz = (float)(-z) * velMul;
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                    world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.5 + x, (double)pos.m_123342_() + 0.5 + y, (double)pos.m_123343_() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean tryCompletePistonRelayBinding(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        GlobalPos bindPos = ((BlockPistonRelay)ModBlocks.pistonRelay).activeBindingAttempts.get(player.m_142081_());
        if (bindPos != null && bindPos.m_122640_() == world.m_46472_()) {
            ((BlockPistonRelay)ModBlocks.pistonRelay).activeBindingAttempts.remove(player.m_142081_());
            BlockPistonRelay.WorldData data = BlockPistonRelay.WorldData.get(world);
            data.mapping.put(bindPos.m_122646_(), pos.m_7949_());
            data.m_77762_();
            IXplatAbstractions.INSTANCE.sendToNear(world, pos, new PacketBotaniaEffect(EffectType.PARTICLE_BEAM, (double)bindPos.m_122646_().m_123341_() + 0.5, (double)bindPos.m_122646_().m_123342_() + 0.5, (double)bindPos.m_122646_().m_123343_() + 0.5, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.ding, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        Direction side = ctx.m_43719_();
        Optional<BlockPos> boundPos = ItemTwigWand.getBindingAttempt(stack);
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            BlockState newState;
            if (boundPos.filter(loc -> ItemTwigWand.tryCompleteBinding(loc, stack, ctx)).isPresent()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_36204_(pos, side, stack) && (!(block instanceof CommandBlock) || player.m_36337_()) && (newState = ItemTwigWand.rotate(state, side.m_122434_())) != state) {
                world.m_46597_(pos, newState);
                return InteractionResult.SUCCESS;
            }
        }
        if (state.m_60713_(Blocks.f_50060_) && BotaniaConfig.common().enchanterEnabled() && ItemTwigWand.tryFormEnchanter(ctx)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        boolean bindable = tile instanceof IWandBindable;
        if (ItemTwigWand.getBindMode(stack) && bindable && player.m_6144_() && ((IWandBindable)tile).canSelect(player, stack, pos, side)) {
            if (boundPos.filter(arg_0 -> ((BlockPos)pos).equals(arg_0)).isPresent()) {
                ItemTwigWand.setBindingAttempt(stack, ITileBound.UNBOUND_POS);
            } else {
                ItemTwigWand.setBindingAttempt(stack, pos);
            }
            if (world.f_46443_) {
                player.m_5496_(ModSounds.ding, 0.11f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        IWandable wandable = IXplatAbstractions.INSTANCE.findWandable(world, pos, state, tile);
        if (wandable != null) {
            return wandable.onUsedByWand(player, stack, side) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        if (!world.f_46443_ && ItemTwigWand.getBindMode(stack) && ItemTwigWand.tryCompletePistonRelayBinding(ctx)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static BlockState rotate(BlockState old, Direction.Axis axis) {
        for (Property prop : old.m_61147_()) {
            Direction newDir;
            Property facingProp;
            Direction oldDir;
            if (!prop.m_61708_().equals("facing") || prop.m_61709_() != Direction.class || (oldDir = (Direction)old.m_61143_(facingProp = prop)) == (newDir = ItemTwigWand.rotateAround(oldDir, axis)) || !facingProp.m_6908_().contains(newDir)) continue;
            return (BlockState)old.m_61124_(facingProp, (Comparable)newDir);
        }
        return old.m_60717_(Rotation.CLOCKWISE_90);
    }

    private static Direction rotateAround(Direction old, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                switch (old) {
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case SOUTH: {
                        yield Direction.UP;
                    }
                    case UP: {
                        yield Direction.NORTH;
                    }
                    case NORTH: {
                        yield Direction.DOWN;
                    }
                }
                yield old;
            }
            case Direction.Axis.Y -> {
                switch (old) {
                    case NORTH: {
                        yield Direction.EAST;
                    }
                    case EAST: {
                        yield Direction.SOUTH;
                    }
                    case SOUTH: {
                        yield Direction.WEST;
                    }
                    case WEST: {
                        yield Direction.NORTH;
                    }
                }
                yield old;
            }
            case Direction.Axis.Z -> {
                switch (old) {
                    case DOWN: {
                        yield Direction.WEST;
                    }
                    case WEST: {
                        yield Direction.UP;
                    }
                    case UP: {
                        yield Direction.EAST;
                    }
                    case EAST: {
                        yield Direction.DOWN;
                    }
                }
                yield old;
            }
        };
    }

    public static void doParticleBeamWithOffset(Level world, BlockPos orig, BlockPos end) {
        Vec3 origOffset = world.m_8055_(orig).m_60824_((BlockGetter)world, orig);
        Vec3 vorig = new Vec3((double)orig.m_123341_() + origOffset.m_7096_() + 0.5, (double)orig.m_123342_() + origOffset.m_7098_() + 0.5, (double)orig.m_123343_() + origOffset.m_7094_() + 0.5);
        Vec3 endOffset = world.m_8055_(end).m_60824_((BlockGetter)world, end);
        Vec3 vend = new Vec3((double)end.m_123341_() + endOffset.m_7096_() + 0.5, (double)end.m_123342_() + endOffset.m_7098_() + 0.5, (double)end.m_123343_() + endOffset.m_7094_() + 0.5);
        ItemTwigWand.doParticleBeam(world, vorig, vend);
    }

    public static void doParticleBeam(Level world, Vec3 orig, Vec3 end) {
        if (!world.f_46443_) {
            return;
        }
        Vec3 diff = end.m_82546_(orig);
        Vec3 movement = diff.m_82541_().m_82490_(0.05);
        int iters = (int)(diff.m_82553_() / movement.m_82553_());
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        Vec3 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            float hue = (float)i * huePer + hueSum;
            int color = Mth.m_14169_((float)Mth.m_14187_((float)hue), (float)1.0f, (float)1.0f);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            SparkleParticleData data = SparkleParticleData.noClip(0.5f, r, g, b, 4);
            IProxy.INSTANCE.addParticleForceNear(world, data, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 0.0, 0.0, 0.0);
            currentPos = currentPos.m_82549_(movement);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        ItemTwigWand.getBindingAttempt(stack).ifPresent(coords -> {
            BlockEntity tile = world.m_7702_(coords);
            if (!(tile instanceof IWandBindable)) {
                ItemTwigWand.setBindingAttempt(stack, ITileBound.UNBOUND_POS);
            }
        });
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!world.f_46443_) {
                ItemTwigWand.setBindMode(stack, !ItemTwigWand.getBindMode(stack));
            } else {
                player.m_5496_(ModSounds.ding, 0.1f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.m_41389_(group)) {
            stacks.add((Object)ItemTwigWand.setColors(new ItemStack((ItemLike)this), 0, 0));
            List<Pair> colorPairs = Arrays.asList(new Pair((Object)0, (Object)3), new Pair((Object)0, (Object)6), new Pair((Object)3, (Object)6), new Pair((Object)10, (Object)11), new Pair((Object)14, (Object)14), new Pair((Object)11, (Object)11), new Pair((Object)1, (Object)1), new Pair((Object)15, (Object)15), new Pair((Object)7, (Object)8), new Pair((Object)6, (Object)7), new Pair((Object)4, (Object)5), new Pair((Object)0, (Object)15));
            Collections.shuffle(colorPairs);
            for (int i = 0; i < 7; ++i) {
                Pair pair = colorPairs.get(i);
                if (Math.random() < 0.5) {
                    pair = new Pair((Object)((Integer)pair.getSecond()), (Object)((Integer)pair.getFirst()));
                }
                stacks.add((Object)ItemTwigWand.setColors(new ItemStack((ItemLike)this), (Integer)pair.getFirst(), (Integer)pair.getSecond()));
            }
        }
    }

    public Component m_7626_(@Nonnull ItemStack stack) {
        MutableComponent mode = new TextComponent(" (").m_7220_((Component)new TranslatableComponent(ItemTwigWand.getModeString(stack)).m_130940_(this.modeChatFormatting)).m_130946_(")");
        return super.m_7626_(stack).m_6879_().m_7220_((Component)mode);
    }

    public static ItemStack setColors(ItemStack wand, int color1, int color2) {
        ItemNBTHelper.setInt(wand, TAG_COLOR1, color1);
        ItemNBTHelper.setInt(wand, TAG_COLOR2, color2);
        return wand;
    }

    public static int getColor1(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
    }

    public static int getColor2(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
    }

    public static void setBindingAttempt(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, pos.m_123341_());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, pos.m_123342_());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, pos.m_123343_());
    }

    public static Optional<BlockPos> getBindingAttempt(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
        return y == Integer.MIN_VALUE ? Optional.empty() : Optional.of(new BlockPos(x, y, z));
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
    }

    public static void setBindMode(ItemStack stack, boolean bindMode) {
        ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
    }

    public static String getModeString(ItemStack stack) {
        return "botaniamisc.wandMode." + (ItemTwigWand.getBindMode(stack) ? "bind" : "function");
    }

    public static class CoordBoundItem
    implements ICoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            Optional<BlockPos> bound = ItemTwigWand.getBindingAttempt(this.stack);
            if (bound.isPresent()) {
                return bound.get();
            }
            HitResult pos = ClientProxy.INSTANCE.getClientHit();
            if (pos instanceof BlockHitResult) {
                BlockEntity tile;
                BlockHitResult bHit = (BlockHitResult)pos;
                if (pos.m_6662_() == HitResult.Type.BLOCK && (tile = world.m_7702_(bHit.m_82425_())) instanceof ITileBound) {
                    ITileBound boundTile = (ITileBound)tile;
                    return boundTile.getBinding();
                }
            }
            return null;
        }
    }
}

